
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
paul = m.addVar(vtype=gp.GRB.INTEGER, name="paul")
john = m.addVar(vtype=gp.GRB.CONTINUOUS, name="john")
bill = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bill")
ringo = m.addVar(vtype=gp.GRB.CONTINUOUS, name="ringo")
dale = m.addVar(vtype=gp.GRB.INTEGER, name="dale")
laura = m.addVar(vtype=gp.GRB.CONTINUOUS, name="laura")


# Set objective function
m.setObjective(5.27 * paul + 8.59 * john + 4.3 * bill + 9.91 * ringo + 5.54 * dale + 8.3 * laura, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(paul + 6 * dale + 4 * laura >= 30)
m.addConstr(2 * john + bill + 3 * ringo >= 30)
m.addConstr(paul + 2 * john + 4 * laura >= 30)
m.addConstr(2 * john + 6 * dale + 4 * laura >= 30)

m.addConstr(paul + 6 * dale + 4 * laura >= 22)
m.addConstr(2 * john + bill + 3 * ringo >= 22)
m.addConstr(paul + 2 * john + 4 * laura >= 22)
m.addConstr(2 * john + 6 * dale + 4 * laura >= 22)

m.addConstr(paul + 6 * dale + 4 * laura >= 20)
m.addConstr(2 * john + bill + 3 * ringo >= 20)
m.addConstr(paul + 2 * john + 4 * laura >= 20)
m.addConstr(2 * john + 6 * dale + 4 * laura >= 20)

m.addConstr(paul + 6 * dale + 4 * laura >= 29)
m.addConstr(2 * john + bill + 3 * ringo >= 29)
m.addConstr(paul + 2 * john + 4 * laura >= 29)
m.addConstr(2 * john + 6 * dale + 4 * laura >= 29)


m.addConstr(5 * paul - 5 * ringo - 9 * laura >= 0)
m.addConstr(7 * john + 6 * bill <= 133)
m.addConstr(6 * bill + 5 * dale <= 50)
m.addConstr(6 * paul + 5 * ringo <= 52)
m.addConstr(5 * ringo + 5 * dale <= 227)
m.addConstr(5 * ringo + 5 * laura <= 46)
m.addConstr(7 * john + 5 * laura <= 117)
m.addConstr(6 * paul + 5 * laura <= 185)
m.addConstr(6 * paul + 7 * john + 5 * ringo <= 130)
m.addConstr(6 * paul + 5 * ringo + 5 * laura <= 212)
m.addConstr(6 * bill + 5 * dale + 5 * laura <= 60)
m.addConstr(7 * john + 6 * bill + 5 * laura <= 43)
m.addConstr(6 * paul + 7 * john + 5 * dale <= 60)
m.addConstr(7 * john + 5 * ringo + 5 * laura <= 178)
m.addConstr(6 * paul + 7 * john + 6 * bill + 5 * ringo + 5 * dale + 5 * laura <= 178)

m.addConstr(paul + 6 * dale <= 162)
m.addConstr(3 * ringo + 6 * dale <= 40)
m.addConstr(6 * dale + 4 * laura <= 150)
m.addConstr(2 * john + 4 * laura <= 188)
m.addConstr(paul + 2 * john + bill <= 97)
m.addConstr(paul + bill + 6 * dale <= 135)
m.addConstr(paul + bill + 3 * ringo <= 70)
m.addConstr(bill + 3 * ringo + 6 * dale <= 52)
m.addConstr(paul + 2 * john + bill + 3 * ringo + 6 * dale + 4 * laura <= 52)

m.addConstr(6 * paul + 7 * john + 6 * bill + 5 * ringo + 5 * dale + 5 * laura <= 235)
m.addConstr(paul + 2 * john + bill + 3 * ringo + 6 * dale + 4 * laura <= 190)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

