
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")  # milligrams of zinc
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")  # grams of protein
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")  # grams of fat
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")  # grams of carbohydrates
x4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x4")  # milligrams of iron
x5 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x5")  # milligrams of vitamin A


# Set objective function
obj = 1.69*x0**2 + 4.26*x0*x1 + 8.96*x0*x2 + 4.54*x0*x3 + 4.93*x0*x4 + 8.07*x0*x5 + 6.36*x1**2 + 2.73*x1*x2 + 1.46*x1*x3 + 8.6*x1*x4 + 1.48*x1*x5 + 7.39*x2**2 + 6.05*x2*x3 + 1.33*x2*x4 + 5.24*x2*x5 + 6.71*x3**2 + 1.2*x3*x4 + 5.68*x3*x5 + 8.23*x4**2 + 2.28*x4*x5 + 1.79*x0 + 7.18*x1 + 2.52*x3 + 7.51*x4 + 9.27*x5
m.setObjective(obj, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x0 + 15*x1 + 14*x2 + 5*x3 + 10*x4 + 4*x5 <= 420)
m.addConstr(14*x0 + 1*x1 + 2*x2 + 10*x3 + 20*x4 + 4*x5 <= 517)
m.addConstr(14*x2**2 + 4*x5**2 >= 24)
m.addConstr(15*x1 + 14*x2 >= 32)
m.addConstr(10*x4**2 + 4*x5**2 >= 45)
m.addConstr(5*x3 + 4*x5 >= 26)
m.addConstr(3*x0 + 15*x1 + 14*x2 + 5*x3 + 10*x4 + 4*x5 >= 26)
m.addConstr(x1 + 2*x2 >= 71)
m.addConstr(14*x0 + x1 >= 78)
m.addConstr(x1**2 + 20*x4**2 >= 65)
m.addConstr(14*x0 + 20*x4 >= 46)
m.addConstr(2*x2**2 + 20*x4**2 >= 78)
m.addConstr(2*x2**2 + 20*x4**2 + 4*x5**2 >= 67)
m.addConstr(14*x0 + x1 + 2*x2 + 10*x3 + 20*x4 + 4*x5 >= 67)
m.addConstr(-7*x0**2 + 3*x1**2 >= 0)
m.addConstr(10*x0 - 2*x3 >= 0)
m.addConstr(3*x0 + 15*x1 + 10*x4 <= 191)
m.addConstr(15*x1 + 10*x4 + 4*x5 <= 377)
m.addConstr(14*x0 + x1 <= 142)
m.addConstr(2*x2 + 4*x5 <= 102)
m.addConstr(10*x3 + 4*x5 <= 327)
m.addConstr(10*x3 + 20*x4 <= 437)
m.addConstr(2*x2**2 + 20*x4**2 <= 441)
m.addConstr(14*x0 + 10*x3 <= 221)
m.addConstr(x1**2 + 20*x4**2 <= 309)
m.addConstr(20*x4 + 4*x5 <= 479)
m.addConstr(14*x0 + x1 + 10*x3 <= 130)
m.addConstr(10*x3 + 20*x4 + 4*x5 <= 135)
m.addConstr(x1 + 2*x2 + 20*x4 <= 407)
m.addConstr(14*x0 + x1 + 20*x4 <= 350)
m.addConstr(14*x0 + 2*x2 + 10*x3 <= 298)
m.addConstr(14*x0 + x1 + 2*x2 <= 377)
m.addConstr(14*x0**2 + 2*x2**2 + 20*x4**2 <= 177)
m.addConstr(14*x0 + 10*x3 + 20*x4 <= 105)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization terminated with status:", m.status)

