
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(7, lb=0.0, name=["x0", "x1", "x2", "x3", "x4", "x5", "x6"])

# Set integer constraints
x[1].vtype = GRB.INTEGER
x[2].vtype = GRB.INTEGER


# Set objective function
m.setObjective(9.77*x[0]**2 + 1.62*x[0]*x[1] + 9.38*x[0]*x[2] + 1.35*x[0]*x[3] + 2.09*x[0]*x[4] + 3.17*x[0]*x[6] + 3.78*x[1]**2 + 5.98*x[1]*x[2] + 4.17*x[1]*x[3] + 2.03*x[1]*x[4] + 4.39*x[1]*x[5] + 3.65*x[1]*x[6] + 6.06*x[2]*x[3] + 3.89*x[2]*x[4] + 9.25*x[2]*x[5] + 3.25*x[2]*x[6] + 4.38*x[3]*x[4] + 4.37*x[3]*x[5] + 8.32*x[3]*x[6] + 6.97*x[4]*x[5] + 6.11*x[4]*x[6] + 6.67*x[5]**2 + 5.59*x[5]*x[6] + 9.35*x[6]**2 + 9.92*x[0] + 9.61*x[1] + 6.44*x[2] + 2.78*x[3] + 6.04*x[4] + 5.71*x[5] + 2.2*x[6], GRB.MINIMIZE)


# Add constraints
m.addConstr(1.58*x[1] + 3.1*x[3] >= 32)
m.addConstr(1.83*x[0] + 2.24*x[4] >= 27)
m.addConstr(1.83*x[0] + 1.85*x[2] >= 29)
m.addConstr(1.83*x[0] + 1.58*x[1] + 1.85*x[2] + 3.1*x[3] + 2.24*x[4] + 1.85*x[5] + 0.44*x[6] >= 29)
m.addConstr(2.3*x[2]**2 + 2.77*x[4]**2 >= 21)
m.addConstr(3.26*x[1]**2 + 2.3*x[2]**2 >= 23)
m.addConstr(2.77*x[4] + 0.06*x[5] >= 26)
m.addConstr(2.77*x[4] + 3.31*x[6] >= 37)
m.addConstr(1.46*x[0]**2 + 3.33*x[3]**2 >= 32)
m.addConstr(1.46*x[0] + 0.06*x[5] >= 28)
m.addConstr(3.26*x[1] + 0.06*x[5] >= 41)
m.addConstr(3.33*x[3] + 3.31*x[6] >= 35)
m.addConstr(3.26*x[1] + 3.31*x[6] >= 27)
m.addConstr(1.46*x[0] + 3.26*x[1] + 2.3*x[2] + 3.33*x[3] + 2.77*x[4] + 0.06*x[5] + 3.31*x[6] >= 27)
m.addConstr(9*x[0] - 2*x[1] >= 0)
m.addConstr(-8*x[0] + 7*x[2] >= 0)
m.addConstr(6*x[5] - 4*x[6] >= 0)
m.addConstr(1.85*x[2]**2 + 3.1*x[3]**2 + 2.24*x[4]**2 <= 204)
m.addConstr(1.83*x[0] + 1.58*x[1] + 3.1*x[3] <= 118)
m.addConstr(1.83*x[0]**2 + 2.24*x[4]**2 + 0.44*x[6]**2 <= 256)
m.addConstr(1.58*x[1] + 3.1*x[3] + 0.44*x[6] <= 175)
m.addConstr(1.58*x[1]**2 + 3.1*x[3]**2 + 2.24*x[4]**2 <= 240)
m.addConstr(1.83*x[0] + 1.58*x[1] + 1.85*x[5] <= 96)
m.addConstr(1.83*x[0] + 1.58*x[1] + 2.24*x[4] <= 92)
m.addConstr(1.85*x[2] + 1.85*x[5] + 0.44*x[6] <= 267)
m.addConstr(1.85*x[2] + 3.1*x[3] + 1.85*x[5] <= 127)
m.addConstr(1.58*x[1] + 1.85*x[5] + 0.44*x[6] <= 193)
m.addConstr(1.83*x[0] + 1.85*x[5] + 0.44*x[6] <= 144)
m.addConstr(1.83*x[0]**2 + 3.1*x[3]**2 + 2.24*x[4]**2 <= 164)
m.addConstr(3.26*x[1]**2 + 2.77*x[4]**2 <= 170)
m.addConstr(1.46*x[0] + 2.3*x[2] + 0.06*x[5] <= 275)
m.addConstr(3.26*x[1]**2 + 2.3*x[2]**2 + 2.77*x[4]**2 <= 230)
m.addConstr(1.46*x[0] + 0.06*x[5] + 3.31*x[6] <= 71)
m.addConstr(1.46*x[0]**2 + 3.26*x[1]**2 + 0.06*x[5]**2 <= 91)
m.addConstr(3.26*x[1] + 2.3*x[2] + 3.33*x[3] <= 236)


r0 = 1.83*x[0] + 1.58*x[1] + 1.85*x[2] + 3.1*x[3] + 2.24*x[4] + 1.85*x[5] + 0.44*x[6] 
r1 = 1.46*x[0] + 3.26*x[1] + 2.3*x[2] + 3.33*x[3] + 2.77*x[4] + 0.06*x[5] + 3.31*x[6]

m.addConstr(r0 <= 328)
m.addConstr(r1 <= 329)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
    print('Obj: %g' % m.objVal)
elif m.status == GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

