
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_b6 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b6")
vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")
vitamin_b7 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b7")
magnesium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magnesium")
vitamin_c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")
vitamin_b5 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b5")


# Set objective function
m.setObjective(5.41 * vitamin_b6 + 5.7 * vitamin_e + 5.02 * vitamin_b7 + 8.15 * magnesium + 6.99 * vitamin_c + 4.23 * vitamin_b5, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(7 * vitamin_b6 + 9 * vitamin_b7 >= 31)
m.addConstr(7 * vitamin_b6 + 7 * vitamin_c + 10 * vitamin_b5 >= 21)
m.addConstr(7 * vitamin_b6 + 9 * vitamin_b7 + 7 * vitamin_c >= 21)
# ... (add all other constraints similarly)

# Add upper bound constraints
m.addConstr(7 * vitamin_b6 + magnesium <= 225)
m.addConstr(7 * vitamin_b6 + 10 * vitamin_b5 <= 85)
# ... (add all other upper bound constraints similarly)

# Add global upper bound constraint
m.addConstr(7 * vitamin_b6 + 6 * vitamin_e + 9 * vitamin_b7 + magnesium + 7 * vitamin_c + 10 * vitamin_b5 <= 134)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('vitamin_b6:', vitamin_b6.x)
    print('vitamin_e:', vitamin_e.x)
    print('vitamin_b7:', vitamin_b7.x)
    print('magnesium:', magnesium.x)
    print('vitamin_c:', vitamin_c.x)
    print('vitamin_b5:', vitamin_b5.x)

elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

