
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
cheeseburgers = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cheeseburgers")
apples = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apples")
cantaloupes = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cantaloupes")
oreos = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="oreos")

# Set objective function
m.setObjective(4*cheeseburgers**2 + 1*cheeseburgers*apples + 9*cheeseburgers*cantaloupes + 5*apples*oreos + 4*cantaloupes*oreos + 4*cheeseburgers + 1*apples + 9*cantaloupes + 6*oreos, GRB.MINIMIZE)

# Add constraints
m.addConstr(4*cheeseburgers + 4*cantaloupes >= 49)
m.addConstr(4*cheeseburgers + 13*apples >= 30)
m.addConstr(4*cantaloupes + 12*oreos >= 62)
m.addConstr(13*apples**2 + 12*oreos**2 >= 48)
m.addConstr(4*cheeseburgers + 13*apples + 4*cantaloupes + 12*oreos >= 48)
m.addConstr(8*cantaloupes + 8*oreos >= 29)
m.addConstr(10*apples**2 + 8*oreos**2 >= 39)
m.addConstr(15*cheeseburgers**2 + 8*cantaloupes**2 >= 63)
m.addConstr(15*cheeseburgers**2 + 10*apples**2 + 8*oreos**2 >= 47)
m.addConstr(15*cheeseburgers + 10*apples + 8*cantaloupes + 8*oreos >= 47)
m.addConstr(18*apples**2 + 10*cantaloupes**2 >= 43)
m.addConstr(18*apples**2 + 5*oreos**2 >= 34)
m.addConstr(9*cheeseburgers + 18*apples >= 15)
m.addConstr(9*cheeseburgers + 18*apples + 10*cantaloupes + 5*oreos >= 15)
m.addConstr(2*cantaloupes + 19*oreos >= 29)
m.addConstr(7*cheeseburgers + 19*oreos >= 43)
m.addConstr(11*apples + 2*cantaloupes >= 17)
m.addConstr(7*cheeseburgers + 2*cantaloupes >= 42)
m.addConstr(7*cheeseburgers + 11*apples + 2*cantaloupes >= 32)
m.addConstr(7*cheeseburgers + 11*apples + 2*cantaloupes + 19*oreos >= 32)
m.addConstr(3*apples - 7*cantaloupes >= 0)
m.addConstr(1*cheeseburgers**2 - 3*oreos**2 >= 0)
m.addConstr(13*apples + 12*oreos <= 191)
m.addConstr(13*apples + 4*cantaloupes <= 223)
m.addConstr(4*cheeseburgers**2 + 13*apples**2 <= 131)
m.addConstr(4*cantaloupes**2 + 12*oreos**2 <= 85)
m.addConstr(4*cheeseburgers + 4*cantaloupes <= 226)
m.addConstr(10*apples**2 + 8*cantaloupes**2 <= 75)
m.addConstr(7*cheeseburgers**2 + 11*apples**2 <= 131)
m.addConstr(7*cheeseburgers + 11*apples + 2*cantaloupes <= 138)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

