
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name='x0', lb=0)  # cheeseburgers
    x1 = model.addVar(name='x1', lb=0)  # apples
    x2 = model.addVar(name='x2', lb=0)  # cantaloupes
    x3 = model.addVar(name='x3', lb=0)  # oreos

    # Objective function
    model.setObjective(4 * x0**2 + x0 * x1 + 9 * x0 * x2 + 5 * x1 * x3 + 4 * x2 * x3 + 4 * x0 + x1 + 9 * x2 + 6 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4 * x0 + 13 * x1 + 4 * x2 + 12 * x3 <= 257)
    model.addConstr(15 * x0 + 10 * x1 + 8 * x2 + 8 * x3 <= 252)
    model.addConstr(9 * x0 + 18 * x1 + 10 * x2 + 5 * x3 <= 186)
    model.addConstr(7 * x0 + 11 * x1 + 2 * x2 + 19 * x3 <= 179)
    model.addConstr(4 * x0 + 4 * x2 >= 49)
    model.addConstr(4 * x0 + 13 * x1 >= 30)
    model.addConstr(4 * x2 + 12 * x3 >= 62)
    model.addConstr(169 * x1**2 + 144 * x3**2 >= 48)
    model.addConstr(4 * x0 + 13 * x1 + 4 * x2 + 12 * x3 >= 48)
    model.addConstr(8 * x2 + 8 * x3 >= 29)
    model.addConstr(100 * x1**2 + 64 * x3**2 >= 39)
    model.addConstr(225 * x0**2 + 64 * x2**2 >= 63)
    model.addConstr(225 * x0**2 + 100 * x1**2 + 64 * x3**2 >= 47)
    model.addConstr(15 * x0 + 10 * x1 + 8 * x2 + 8 * x3 >= 47)
    model.addConstr(324 * x1**2 + 100 * x2**2 >= 43)
    model.addConstr(324 * x1**2 + 25 * x3**2 >= 34)
    model.addConstr(9 * x0 + 18 * x1 >= 15)
    model.addConstr(9 * x0 + 18 * x1 + 10 * x2 + 5 * x3 >= 15)
    model.addConstr(2 * x2 + 19 * x3 >= 29)
    model.addConstr(7 * x0 + 19 * x3 >= 43)
    model.addConstr(11 * x1 + 2 * x2 >= 17)
    model.addConstr(7 * x0 + 2 * x2 >= 42)
    model.addConstr(7 * x0 + 11 * x1 + 2 * x2 >= 32)
    model.addConstr(7 * x0 + 11 * x1 + 2 * x2 + 19 * x3 >= 32)
    model.addConstr(3 * x1 - 7 * x2 >= 0)
    model.addConstr(x0**2 - 3 * x3**2 >= 0)
    model.addConstr(13 * x1 + 12 * x3 <= 191)
    model.addConstr(13 * x1 + 4 * x2 <= 223)
    model.addConstr(16 * x0**2 + 169 * x1**2 <= 131)
    model.addConstr(16 * x2**2 + 144 * x3**2 <= 85)
    model.addConstr(4 * x0 + 4 * x2 <= 226)
    model.addConstr(100 * x1**2 + 64 * x2**2 <= 75)
    model.addConstr(49 * x0**2 + 121 * x1**2 <= 131)
    model.addConstr(7 * x0 + 11 * x1 + 2 * x2 <= 138)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"cheeseburgers: {x0.varValue}")
        print(f"apples: {x1.varValue}")
        print(f"cantaloupes: {x2.varValue}")
        print(f"oreos: {x3.varValue}")
    else:
        print("No optimal solution found.")

optimize_problem()
