
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("minimize_impact")

    # Create variables
    security_onions = model.addVar(vtype=gp.GRB.INTEGER, name="security_onions")
    pen_testers = model.addVar(vtype=gp.GRB.INTEGER, name="pen_testers")


    # Set objective function
    model.setObjective(7.64 * security_onions + 2.51 * pen_testers, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(7 * security_onions + 11 * pen_testers >= 12, "network_integrity_min")
    model.addConstr(10 * security_onions + 5 * pen_testers >= 8, "data_integrity_min")
    model.addConstr(3 * security_onions - 8 * pen_testers >= 0, "resource_constraint")
    model.addConstr(7 * security_onions + 11 * pen_testers <= 60, "network_integrity_max")
    model.addConstr(10 * security_onions + 5 * pen_testers <= 32, "data_integrity_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal solution:")
        print(f"Security Onions: {security_onions.x}")
        print(f"Pen Testers: {pen_testers.x}")
        print(f"Objective Value: {model.objVal}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
