
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="security_onions")
x2 = m.addVar(vtype=GRB.INTEGER, name="pen_testers")

# Set the objective function
m.setObjective(7.64*x1 + 2.51*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(7*x1 + 11*x2 >= 12, "network_integrity_min")
m.addConstr(7*x1 + 11*x2 <= 60, "network_integrity_max")
m.addConstr(10*x1 + 5*x2 >= 8, "data_integrity_min")
m.addConstr(10*x1 + 5*x2 <= 32, "data_integrity_max")
m.addConstr(3*x1 - 8*x2 >= 0, "additional_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Security Onions: {x1.x}")
    print(f"Pen Testers: {x2.x}")
else:
    print("No optimal solution found")
