
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='security_onions', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='pen_testers', vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(7.64 * x1 + 2.51 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(7 * x1 + 11 * x2 >= 12, name='network_integrity_impact')
    model.addConstr(10 * x1 + 5 * x2 >= 8, name='data_integrity_impact')
    model.addConstr(3 * x1 - 8 * x2 >= 0, name='additional_constraint')
    model.addConstr(7 * x1 + 11 * x2 <= 74, name='network_integrity_impact_upper_bound')
    model.addConstr(10 * x1 + 5 * x2 <= 33, name='data_integrity_impact_upper_bound')

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: security onions = {x1.varValue}, pen testers = {x2.varValue}")
    else:
        print("No optimal solution found")

solve_optimization_problem()
