
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    vitamin_k = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_k")
    vitamin_b3 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_b3")
    fat = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fat")


    # Set objective function
    m.setObjective(5*vitamin_k + 2*vitamin_b3 + 6*fat, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4*vitamin_b3 + 2*fat >= 24, "kidney_support_b3_fat")
    m.addConstr(8*vitamin_k + 2*fat >= 47, "energy_stability_k_fat")
    m.addConstr(3*vitamin_k + 6*fat >= 26, "cognitive_performance_k_fat")
    m.addConstr(9*vitamin_k + 4*vitamin_b3 <= 158, "kidney_support_k_b3")
    m.addConstr(9*vitamin_k + 2*fat <= 142, "kidney_support_k_fat_limit")
    m.addConstr(9*vitamin_k + 4*vitamin_b3 + 2*fat <= 115, "kidney_support_total")
    m.addConstr(7*vitamin_b3 + 2*fat <= 138, "energy_stability_b3_fat")
    m.addConstr(8*vitamin_k + 7*vitamin_b3 <= 131, "energy_stability_k_b3")
    m.addConstr(8*vitamin_k + 2*fat <= 90, "energy_stability_k_fat_limit")
    m.addConstr(8*vitamin_k + 7*vitamin_b3 + 2*fat <= 93, "energy_stability_total")
    m.addConstr(9*vitamin_b3 + 6*fat <= 49, "cognitive_performance_b3_fat")
    m.addConstr(3*vitamin_k + 9*vitamin_b3 + 6*fat <= 49, "cognitive_performance_total")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('vitamin_k:', vitamin_k.x)
        print('vitamin_b3:', vitamin_b3.x)
        print('fat:', fat.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
