
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0") # hours worked by Mary
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="x1") # hours worked by Laura
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # hours worked by Ringo
    x3 = m.addVar(vtype=gp.GRB.INTEGER, name="x3") # hours worked by Jean


    # Set objective function
    m.setObjective(6*x0 + 6*x1 + 8*x2 + 7*x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(7*x0 + 22*x1 >= 85)
    m.addConstr(7*x0 + 12*x3 >= 69)
    m.addConstr(7*x0 + 28*x2 >= 119)
    m.addConstr(22*x1 + 12*x3 >= 76)
    m.addConstr(22*x1 + 28*x2 >= 83)
    m.addConstr(7*x0 + 22*x1 + 28*x2 >= 144)
    m.addConstr(7*x0 + 28*x2 + 12*x3 >= 144)
    m.addConstr(22*x1 + 28*x2 + 12*x3 >= 144)
    m.addConstr(7*x0 + 22*x1 + 12*x3 >= 144)
    m.addConstr(7*x0 + 22*x1 + 28*x2 >= 90) # Redundant
    m.addConstr(7*x0 + 28*x2 + 12*x3 >= 90) # Redundant
    m.addConstr(22*x1 + 28*x2 + 12*x3 >= 90) # Redundant
    m.addConstr(7*x0 + 22*x1 + 12*x3 >= 90) # Redundant
    m.addConstr(7*x0 + 22*x1 + 28*x2 >= 86) # Redundant
    m.addConstr(7*x0 + 28*x2 + 12*x3 >= 86) # Redundant
    m.addConstr(22*x1 + 28*x2 + 12*x3 >= 86) # Redundant
    m.addConstr(7*x0 + 22*x1 + 12*x3 >= 86) # Redundant
    m.addConstr(7*x0 + 22*x1 + 28*x2 >= 145)
    m.addConstr(7*x0 + 28*x2 + 12*x3 >= 145)
    m.addConstr(22*x1 + 28*x2 + 12*x3 >= 145)
    m.addConstr(7*x0 + 22*x1 + 12*x3 >= 145)
    m.addConstr(7*x0 + 22*x1 + 28*x2 + 12*x3 >= 145)
    m.addConstr(-3*x1 + 5*x2 >= 0)
    m.addConstr(7*x2 - 5*x3 >= 0)
    m.addConstr(7*x0 + 12*x3 <= 269)
    m.addConstr(22*x1 + 28*x2 <= 322)
    m.addConstr(28*x2 + 12*x3 <= 389)
    m.addConstr(7*x0 + 28*x2 + 12*x3 <= 496)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
