
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='hours_worked_by_Mary')
x2 = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype='I', name='hours_worked_by_Laura')
x3 = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='hours_worked_by_Ringo')
x4 = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype='I', name='hours_worked_by_Jean')

# Objective function
m.setObjective(6 * x1 + 6 * x2 + 8 * x3 + 7 * x4, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(7 * x1 + 22 * x2 >= 85)
m.addConstr(7 * x1 + 12 * x4 >= 69)
m.addConstr(7 * x1 + 28 * x3 >= 119)
m.addConstr(22 * x2 + 12 * x4 >= 76)
m.addConstr(22 * x2 + 28 * x3 >= 83)
m.addConstr(7 * x1 + 22 * x2 + 28 * x3 >= 144)
m.addConstr(7 * x1 + 28 * x3 + 12 * x4 >= 144)
m.addConstr(22 * x2 + 28 * x3 + 12 * x4 >= 144)
m.addConstr(7 * x1 + 22 * x2 + 12 * x4 >= 144)
m.addConstr(7 * x1 + 22 * x2 + 28 * x3 >= 90)
m.addConstr(7 * x1 + 28 * x3 + 12 * x4 >= 90)
m.addConstr(22 * x2 + 28 * x3 + 12 * x4 >= 90)
m.addConstr(7 * x1 + 22 * x2 + 12 * x4 >= 90)
m.addConstr(7 * x1 + 22 * x2 + 28 * x3 >= 86)
m.addConstr(7 * x1 + 28 * x3 + 12 * x4 >= 86)
m.addConstr(22 * x2 + 28 * x3 + 12 * x4 >= 86)
m.addConstr(7 * x1 + 22 * x2 + 12 * x4 >= 86)
m.addConstr(7 * x1 + 22 * x2 + 28 * x3 >= 145)
m.addConstr(7 * x1 + 28 * x3 + 12 * x4 >= 145)
m.addConstr(22 * x2 + 28 * x3 + 12 * x4 >= 145)
m.addConstr(7 * x1 + 22 * x2 + 12 * x4 >= 145)
m.addConstr(7 * x1 + 22 * x2 + 28 * x3 + 12 * x4 >= 145)
m.addConstr(-3 * x2 + 5 * x3 >= 0)
m.addConstr(7 * x3 - 5 * x4 >= 0)
m.addConstr(7 * x1 + 12 * x4 <= 269)
m.addConstr(22 * x2 + 28 * x3 <= 322)
m.addConstr(28 * x3 + 12 * x4 <= 389)
m.addConstr(7 * x1 + 28 * x3 + 12 * x4 <= 496)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objval)
    print('Hours worked by Mary: ', x1.varValue)
    print('Hours worked by Laura: ', x2.varValue)
    print('Hours worked by Ringo: ', x3.varValue)
    print('Hours worked by Jean: ', x4.varValue)
else:
    print('No solution found')
