
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    bobby_hours = model.addVar(vtype=GRB.INTEGER, name="bobby_hours")
    john_hours = model.addVar(vtype=GRB.INTEGER, name="john_hours")
    paul_hours = model.addVar(vtype=GRB.INTEGER, name="paul_hours")


    # Set objective function
    model.setObjective(bobby_hours*john_hours + 5*john_hours**2 + 8*john_hours*paul_hours + 5*paul_hours**2 + john_hours + 8*paul_hours, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(6*bobby_hours + 16*john_hours + 17*paul_hours >= 21, "c0")
    model.addConstr(12*bobby_hours**2 + 14*john_hours**2 <= 64, "c1")
    model.addConstr(12*bobby_hours + 13*paul_hours <= 104, "c2")
    model.addConstr(12*bobby_hours + 14*john_hours + 13*paul_hours <= 104, "c3")
    model.addConstr(20*bobby_hours + 7*john_hours <= 88, "c4")
    model.addConstr(20*bobby_hours + 7*paul_hours <= 62, "c5")
    model.addConstr(20*bobby_hours + 7*john_hours + 7*paul_hours <= 62, "c6")
    model.addConstr(6*bobby_hours + 17*paul_hours <= 69, "c7")
    model.addConstr(6*bobby_hours + 16*john_hours <= 39, "c8")
    model.addConstr(6*bobby_hours + 16*john_hours + 17*paul_hours <= 98, "c9")
    model.addConstr(15*john_hours + 7*paul_hours <= 109, "c10")
    model.addConstr(17*bobby_hours + 15*john_hours <= 73, "c11")
    model.addConstr(17*bobby_hours + 15*john_hours + 7*paul_hours <= 73, "c12")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Bobby Hours: %g' % bobby_hours.x)
        print('John Hours: %g' % john_hours.x)
        print('Paul Hours: %g' % paul_hours.x)
    elif model.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
