
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="x0", vtype=gp.GRB.INTEGER)  # hours worked by Bobby
x1 = m.addVar(name="x1", vtype=gp.GRB.INTEGER)  # hours worked by John
x2 = m.addVar(name="x2", vtype=gp.GRB.INTEGER)  # hours worked by Paul

# Objective function
m.setObjective(x0 * x1 + 5 * x1 ** 2 + 8 * x1 * x2 + 5 * x2 ** 2 + x1 + 8 * x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(12 * x0 == 12, name="bobby_paperwork")
m.addConstr(6 * x0 == 6, name="bobby_organization")
m.addConstr(17 * x0 == 17, name="bobby_likelihood")

m.addConstr(14 * x1 == 14, name="john_paperwork")
m.addConstr(7 * x1 == 7, name="john_cost")
m.addConstr(16 * x1 == 16, name="john_organization")
m.addConstr(15 * x1 == 15, name="john_likelihood")

m.addConstr(13 * x2 == 13, name="paul_paperwork")
m.addConstr(7 * x2 == 7, name="paul_cost")
m.addConstr(17 * x2 == 17, name="paul_organization")
m.addConstr(7 * x2 == 7, name="paul_likelihood")

m.addConstr(6 * x0 + 16 * x1 + 17 * x2 >= 21, name="total_organization")
m.addConstr(12 * x0 ** 2 + 14 * x1 ** 2 <= 64, name="paperwork_competence")
m.addConstr(12 * x0 + 13 * x2 <= 104, name="paperwork_competence_bobby_paul")
m.addConstr(12 * x0 + 14 * x1 + 13 * x2 <= 104, name="paperwork_competence_all")
m.addConstr(20 * x0 + 7 * x1 <= 88, name="dollar_cost_bobby_john")
m.addConstr(20 * x0 + 7 * x2 <= 62, name="dollar_cost_bobby_paul")
m.addConstr(20 * x0 + 7 * x1 + 7 * x2 <= 62, name="dollar_cost_all")
m.addConstr(6 * x0 + 17 * x2 <= 69, name="organization_bobby_paul")
m.addConstr(6 * x0 + 16 * x1 <= 39, name="organization_bobby_john")
m.addConstr(6 * x0 + 16 * x1 + 17 * x2 <= 98, name="organization_all")
m.addConstr(15 * x1 + 7 * x2 <= 109, name="likelihood_john_paul")
m.addConstr(17 * x0 + 15 * x1 <= 73, name="likelihood_bobby_john")
m.addConstr(17 * x0 + 15 * x1 + 7 * x2 <= 73, name="likelihood_all")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Bobby: ", x0.varValue)
    print("Hours worked by John: ", x1.varValue)
    print("Hours worked by Paul: ", x2.varValue)
else:
    print("The model is infeasible")
