
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
pickles = m.addVar(vtype=GRB.INTEGER, name="pickles")
cantaloupes = m.addVar(vtype=GRB.CONTINUOUS, name="cantaloupes")

# Set objective function
m.setObjective(5*pickles**2 + 2*pickles*cantaloupes + 5*cantaloupes**2 + 2*pickles + 2*cantaloupes, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*pickles + 11*cantaloupes >= 24, "calcium_min")
m.addConstr(10*pickles + 4*cantaloupes >= 9, "sourness_min")
m.addConstr(4*pickles**2 + 1*cantaloupes**2 >= 25, "cost_min_sq")
m.addConstr(4*pickles + 1*cantaloupes >= 25, "cost_min")
m.addConstr(3*pickles - 6*cantaloupes >= 0, "pickles_cantaloupes_ratio")
m.addConstr(5*pickles + 11*cantaloupes <= 76, "calcium_max")
m.addConstr(10*pickles**2 + 4*cantaloupes**2 <= 32, "sourness_max_sq")
m.addConstr(4*pickles + 1*cantaloupes <= 48, "cost_max")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('pickles:', pickles.x)
    print('cantaloupes:', cantaloupes.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

