
import gurobi

def solve_optimization_problem():
    # Create a new model
    m = gurobi.Model()

    # Define variables
    x1 = m.addVar(name="pickles", vtype=gurobi.GRB.INTEGER)  # Integer for pickles
    x2 = m.addVar(name="cantaloupes")  # Continuous for cantaloupes

    # Objective function
    m.setObjective(5*x1**2 + 2*x1*x2 + 5*x2**2 + 2*x1 + 2*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    m.addConstr(5*x1 + 11*x2 >= 24, name="calcium_min")
    m.addConstr(5*x1 >= 24, name="calcium_from_pickles_min")
    m.addConstr(10*x1 + 4*x2 >= 9, name="sourness_min")
    m.addConstr(3*x1 - 6*x2 >= 0, name="relationship")
    m.addConstr(5*x1 + 11*x2 <= 76, name="calcium_max")
    m.addConstr(100*x1**2 + 16*x2**2 <= 32, name="sourness_squared_max")
    m.addConstr(4*x1 + x2 >= 25, name="cost_min")
    m.addConstr(4*x1 + x2 <= 48, name="cost_max")

    # Optimize
    m.optimize()

    # Print solution
    if m.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", m.objVal)
        print("Pickles: ", x1.varValue)
        print("Cantaloupes: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
