
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    planners = m.addVar(vtype=gp.GRB.INTEGER, name="planners")
    staplers = m.addVar(vtype=gp.GRB.INTEGER, name="staplers")
    color_printers = m.addVar(vtype=gp.GRB.INTEGER, name="color_printers")
    headsets = m.addVar(vtype=gp.GRB.INTEGER, name="headsets")
    cafeteria_chairs = m.addVar(vtype=gp.GRB.INTEGER, name="cafeteria_chairs")

    # Set objective function
    m.setObjective(1.3 * planners + 8.78 * staplers + 8.21 * color_printers + 4.35 * headsets + 7.78 * cafeteria_chairs, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(6 * staplers + 3 * cafeteria_chairs >= 7)
    m.addConstr(3 * color_printers + 3 * cafeteria_chairs >= 4)
    m.addConstr(3 * planners + 6 * staplers >= 8)
    m.addConstr(6 * staplers + 3 * color_printers >= 10)
    m.addConstr(3 * planners + 7 * headsets >= 10)
    m.addConstr(3 * planners + 3 * cafeteria_chairs >= 4)
    m.addConstr(3 * color_printers + 7 * headsets >= 4)
    m.addConstr(6 * staplers + 7 * headsets >= 12)
    m.addConstr(2 * planners - 6 * staplers >= 0)
    m.addConstr(7 * headsets + 3 * cafeteria_chairs <= 56)
    m.addConstr(3 * color_printers + 3 * cafeteria_chairs <= 26)
    m.addConstr(6 * staplers + 7 * headsets <= 21)
    m.addConstr(3 * planners + 3 * color_printers <= 13)
    m.addConstr(3 * planners + 6 * staplers <= 44)
    m.addConstr(3 * planners + 7 * headsets + 3 * cafeteria_chairs <= 23)
    m.addConstr(3 * planners + 6 * staplers + 3 * color_printers <= 32)
    m.addConstr(3 * planners + 3 * color_printers + 3 * cafeteria_chairs <= 15)
    m.addConstr(6 * staplers + 7 * headsets + 3 * cafeteria_chairs <= 20)
    m.addConstr(3 * planners + 6 * staplers + 3 * cafeteria_chairs <= 51)
    m.addConstr(3 * planners + 3 * color_printers + 7 * headsets <= 55)
    m.addConstr(3 * planners + 6 * staplers + 7 * headsets <= 27)
    m.addConstr(3 * planners + 6 * staplers + 3 * color_printers + 7 * headsets + 3 * cafeteria_chairs <= 27)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName} = {v.x}')
        print(f'Objective Value: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Gurobi error: {e}")
except AttributeError:
    print("Encountered an attribute error. Check variable names and model attributes.")

