
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='planners', vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name='staplers', vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name='color_printers', vtype=gurobi.GRB.INTEGER)
x4 = m.addVar(name='headsets', vtype=gurobi.GRB.INTEGER)
x5 = m.addVar(name='cafeteria_chairs', vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(1.3*x1 + 8.78*x2 + 8.21*x3 + 4.35*x4 + 7.78*x5, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 <= 62)
m.addConstr(6*x2 <= 62)
m.addConstr(3*x3 <= 62)
m.addConstr(7*x4 <= 62)
m.addConstr(3*x5 <= 62)
m.addConstr(6*x2 + 3*x5 >= 7)
m.addConstr(3*x3 + 3*x5 >= 4)
m.addConstr(3*x1 + 6*x2 >= 8)
m.addConstr(6*x2 + 3*x3 >= 10)
m.addConstr(3*x1 + 7*x4 >= 10)
m.addConstr(3*x1 + 3*x5 >= 4)
m.addConstr(3*x3 + 7*x4 >= 4)
m.addConstr(6*x2 + 7*x4 >= 12)
m.addConstr(2*x1 - 6*x2 >= 0)
m.addConstr(7*x4 + 3*x5 <= 56)
m.addConstr(3*x3 + 3*x5 <= 26)
m.addConstr(6*x2 + 7*x4 <= 21)
m.addConstr(3*x1 + 3*x3 <= 13)
m.addConstr(3*x1 + 6*x2 <= 44)
m.addConstr(3*x1 + 7*x4 + 3*x5 <= 23)
m.addConstr(3*x1 + 6*x2 + 3*x3 <= 32)
m.addConstr(3*x1 + 3*x3 + 3*x5 <= 15)
m.addConstr(6*x2 + 7*x4 + 3*x5 <= 20)
m.addConstr(3*x1 + 6*x2 + 3*x5 <= 51)
m.addConstr(3*x1 + 3*x3 + 7*x4 <= 55)
m.addConstr(3*x1 + 6*x2 + 7*x4 <= 27)
m.addConstr(3*x1 + 6*x2 + 3*x3 + 7*x4 + 3*x5 <= 27)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('planners: ', x1.varValue)
    print('staplers: ', x2.varValue)
    print('color_printers: ', x3.varValue)
    print('headsets: ', x4.varValue)
    print('cafeteria_chairs: ', x5.varValue)
else:
    print('No solution found')
