
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    napkins = model.addVar(vtype=gp.GRB.INTEGER, name="napkins")
    dish_soap = model.addVar(vtype=gp.GRB.INTEGER, name="dish_soap")

    # Set objective function
    model.setObjective(4 * napkins + 1 * dish_soap, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(3 * napkins + 3 * dish_soap >= 16, "cost_min")
    model.addConstr(1 * napkins + 8 * dish_soap >= 8, "usefulness_min")
    model.addConstr(1 * napkins + 1 * dish_soap >= 13, "sustainability_min")
    model.addConstr(-1 * napkins + 2 * dish_soap >= 0, "napkins_dish_soap_relation")
    model.addConstr(3 * napkins + 3 * dish_soap <= 32, "cost_max")
    model.addConstr(1 * napkins + 8 * dish_soap <= 26, "usefulness_max")
    model.addConstr(1 * napkins + 1 * dish_soap <= 32, "sustainability_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal solution found:")
        print(f"Packs of napkins: {napkins.x}")
        print(f"Dish soap bottles: {dish_soap.x}")
        print(f"Objective value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print("Encountered an attribute error")
