
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="packs_of_napkins")
x1 = m.addVar(vtype=GRB.INTEGER, name="dish_soap_bottles")

# Objective function
m.setObjective(4*x0 + x1, GRB.MINIMIZE)

# Constraints
m.addConstr(3*x0 + 3*x1 >= 16, "minimum_spend")
m.addConstr(3*x0 + 3*x1 <= 32, "maximum_spend")
m.addConstr(x0 + 8*x1 >= 8, "minimum_usefulness")
m.addConstr(x0 + 8*x1 <= 26, "maximum_usefulness")
m.addConstr(x0 + x1 >= 13, "minimum_sustainability")
m.addConstr(x0 + x1 <= 32, "maximum_sustainability")
m.addConstr(-x0 + 2*x1 >= 0, "additional_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Packs of napkins: {x0.x}")
    print(f"Dish soap bottles: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
