
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="packs_of_napkins", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="dish_soap_bottles", vtype=gurobi.GRB.INTEGER)

    # Objective function: Minimize 4*x1 + x2
    model.setObjective(4 * x1 + x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3 * x1 + 3 * x2 >= 16, name="min_spend")
    model.addConstr(x1 + 8 * x2 >= 8, name="min_usefulness")
    model.addConstr(x1 + x2 >= 13, name="min_sustainability")
    model.addConstr(-x1 + 2 * x2 >= 0, name="relationship")
    model.addConstr(3 * x1 + 3 * x2 <= 32, name="max_spend")
    model.addConstr(x1 + 8 * x2 <= 26, name="max_usefulness")
    model.addConstr(x1 + x2 <= 40, name="max_sustainability")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("packs_of_napkins: ", x1.varValue)
        print("dish_soap_bottles: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
