
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Create variables
x = {}
item_names = ['wooden pencils', 'rubber bands', 'smoke detectors', 'scissors', 'packs of paper', 'blue highlighters', 'hole punches']
for i in range(len(item_names)):
    x[i] = m.addVar(vtype=GRB.INTEGER, name=item_names[i])

# Set objective function
m.setObjective(8*x[0] + 2*x[1] + 7*x[2] + 5*x[3] + 9*x[4] + 7*x[5] + x[6], GRB.MAXIMIZE)

# Add sustainability and usefulness constraints
sustainability_coeffs = [1, 14, 4, 5, 10, 1, 3]
usefulness_coeffs = [9, 10, 1, 12, 3, 9, 12]

m.addConstr(quicksum(sustainability_coeffs[i] * x[i] for i in range(len(item_names))) <= 226, "r0")
m.addConstr(quicksum(usefulness_coeffs[i] * x[i] for i in range(len(item_names))) <= 467, "r1")


# Add other constraints from the input
constraints = [
    (3, 5, 6, 18, ">="), (2, 3, 5, 18, ">="), (0, 1, 5, 18, ">="), (0, 1, 2, 18, ">="),
    (2, 5, 6, 18, ">="), (2, 3, 4, 18, ">="), (3, 4, 6, 18, ">="), (0, 3, 5, 18, ">="),
    (0, 1, 4, 18, ">="), (1, 2, 5, 18, ">="), (0, 5, 6, 18, ">="), (0, 2, 4, 18, ">="),
    (0, 4, 5, 18, ">="), (2, 3, 6, 18, ">="), (3, 5, 6, 28, ">="), (2, 3, 5, 28, ">="),
    (0, 1, 5, 28, ">="), (0, 1, 2, 28, ">="), (2, 5, 6, 28, ">="), (2, 3, 4, 28, ">="),
    (3, 4, 6, 28, ">="), (0, 3, 5, 28, ">="), (0, 1, 4, 28, ">="), (1, 2, 5, 28, ">="),
    (0, 5, 6, 28, ">="), (0, 2, 4, 28, ">="), (0, 4, 5, 28, ">="), (2, 3, 6, 28, ">="),
    (0, 2, 171, "<="), (0, 4, 179, "<="), (3, 4, 209, "<="), (5, 6, 226, "<="),
    (4, 6, 115, "<="), (0, 1, 115, "<="), (2, 4, 174, "<="), (2, 4, 5, 86, "<="),
    (1, 2, 6, 109, "<="), (0, 3, 5, 129, "<="), (0, 4, 6, 83, "<="), (0, 4, 5, 54, "<="),
    (1, 4, 6, 222, "<="), (0, 5, 6, 72, "<="), (2, 4, 6, 93, "<="),
    (0, 1, 2, 3, 4, 5, 6, 93, "<=")
]

for constraint in constraints:
    indices = constraint[:-2]
    rhs = constraint[-2]
    operator = constraint[-1]

    expr = quicksum(sustainability_coeffs[i] * x[i] if isinstance(i, int) else x[i] for i in indices if i is not None)

    if operator == ">=":
        m.addConstr(expr >= rhs)
    elif operator == "<=":
        m.addConstr(expr <= rhs)

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

