
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="wooden_pencils", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="rubber_bands", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="smoke_detectors", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="scissors", vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name="packs_of_paper", vtype=gurobi.GRB.INTEGER)
    x5 = model.addVar(name="blue_highlighters", vtype=gurobi.GRB.INTEGER)
    x6 = model.addVar(name="hole_punches", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(8*x0 + 2*x1 + 7*x2 + 5*x3 + 9*x4 + 7*x5 + x6, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x0 + 14*x1 + 4*x2 + 5*x3 + 10*x4 + x5 + 3*x6 <= 226)
    model.addConstr(9*x0 + 10*x1 + x2 + 12*x3 + 3*x4 + 9*x5 + 12*x6 <= 467)

    # Add other constraints...

    model.addConstr(x0 + 14*x1 + x5 + 3*x6 >= 18)
    model.addConstr(4*x2 + 5*x3 + x5 + 3*x6 >= 18)
    model.addConstr(x0 >= 0)
    model.addConstr(x1 >= 0)
    model.addConstr(x2 >= 0)
    model.addConstr(x3 >= 0)
    model.addConstr(x4 >= 0)
    model.addConstr(x5 >= 0)
    model.addConstr(x6 >= 0)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Wooden pencils: ", x0.varValue)
        print("Rubber bands: ", x1.varValue)
        print("Smoke detectors: ", x2.varValue)
        print("Scissors: ", x3.varValue)
        print("Packs of paper: ", x4.varValue)
        print("Blue highlighters: ", x5.varValue)
        print("Hole punches: ", x6.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
