
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Minimize Hours")

    # Create variables
    dale_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale_hours")
    bill_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill_hours")


    # Set objective function
    model.setObjective(dale_hours + bill_hours, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(25 * dale_hours + 21 * bill_hours >= 43, "work_quality_min")
    model.addConstr(20 * dale_hours + 1 * bill_hours >= 36, "organization_min")
    model.addConstr(11 * dale_hours + 27 * bill_hours >= 47, "paperwork_min")
    model.addConstr(-8 * dale_hours + 2 * bill_hours >= 0, "dale_bill_ratio")
    model.addConstr(25 * dale_hours + 21 * bill_hours <= 80, "work_quality_max")
    model.addConstr(20 * dale_hours + 1 * bill_hours <= 105, "organization_max")
    model.addConstr(11 * dale_hours + 27 * bill_hours <= 65, "paperwork_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print(f"Dale's Hours: {dale_hours.x}")
        print(f"Bill's Hours: {bill_hours.x}")
        print(f"Total Hours: {dale_hours.x + bill_hours.x}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
