
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(name='hours_worked_by_Dale', lb=0)
x1 = m.addVar(name='hours_worked_by_Bill', lb=0)

# Set objective function
m.setObjective(x0 + x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(25*x0 + 21*x1 >= 43, name='work_quality_rating')
m.addConstr(20*x0 + x1 >= 36, name='organization_score')
m.addConstr(11*x0 + 27*x1 >= 47, name='paperwork_competence_rating')
m.addConstr(-8*x0 + 2*x1 >= 0, name='linear_inequality_constraint')
m.addConstr(25*x0 + 21*x1 <= 80, name='upper_bound_work_quality_rating')
m.addConstr(20*x0 + x1 <= 105, name='upper_bound_organization_score')
m.addConstr(11*x0 + 27*x1 <= 65, name='upper_bound_paperwork_competence_rating')

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Hours worked by Dale: {x0.x}')
    print(f'Hours worked by Bill: {x1.x}')
else:
    print('No optimal solution found')
