
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='hours_worked_by_Dale', lb=0)  # Assuming hours cannot be negative
    x2 = model.addVar(name='hours_worked_by_Bill', lb=0)  # Assuming hours cannot be negative

    # Define the objective function
    model.setObjective(x1 + x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(25*x1 + 21*x2 >= 43, name='work_quality_rating')
    model.addConstr(20*x1 + x2 >= 36, name='organization_score')
    model.addConstr(11*x1 + 27*x2 >= 47, name='paperwork_competence_rating')
    model.addConstr(-8*x1 + 2*x2 >= 0, name='hourly_constraint')
    model.addConstr(25*x1 + 21*x2 <= 80, name='work_quality_upper_bound')
    model.addConstr(20*x1 + x2 <= 105, name='organization_upper_bound')
    model.addConstr(11*x1 + 27*x2 <= 65, name='paperwork_upper_bound')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Hours worked by Dale: {x1.varValue}')
        print(f'Hours worked by Bill: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
