
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    chicken_breasts = m.addVar(name="chicken_breasts")
    hamburgers = m.addVar(name="hamburgers", vtype=gp.GRB.INTEGER)
    kiwis = m.addVar(name="kiwis", vtype=gp.GRB.INTEGER)


    # Set objective function
    m.setObjective(2.97*chicken_breasts**2 + 7.99*chicken_breasts*hamburgers + 5.42*chicken_breasts*kiwis + 8.42*hamburgers**2 + 5.13*hamburgers*kiwis + 9.59*chicken_breasts + 9.47*hamburgers + 1.94*kiwis, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(chicken_breasts + 9*hamburgers + 12*kiwis <= 386, "c0")
    m.addConstr(24*chicken_breasts + 26*hamburgers + 26*kiwis <= 238, "c1")
    m.addConstr(chicken_breasts**2 + kiwis**2 >= 70, "c2")
    m.addConstr(hamburgers**2 + kiwis**2 >= 67, "c3")
    m.addConstr(chicken_breasts + hamburgers >= 88, "c4")
    m.addConstr(chicken_breasts + hamburgers + kiwis >= 88, "c5")
    m.addConstr(hamburgers + kiwis >= 41, "c6")
    m.addConstr(chicken_breasts + hamburgers >= 60, "c7")
    m.addConstr(chicken_breasts + hamburgers + kiwis >= 60, "c8")
    m.addConstr(-6*chicken_breasts + 5*kiwis >= 0, "c9")
    m.addConstr(hamburgers**2 + kiwis**2 <= 383, "c10")
    m.addConstr(chicken_breasts + kiwis <= 317, "c11")
    m.addConstr(chicken_breasts**2 + hamburgers**2 + kiwis**2 <= 355, "c12")
    m.addConstr(chicken_breasts + kiwis <= 161, "c13")
    m.addConstr(chicken_breasts**2 + hamburgers**2 + kiwis**2 <= 107, "c14")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
