
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=0, name="chicken_breasts")  # No lower bound given, assuming non-negative
    x1 = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="hamburgers")
    x2 = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="kiwis")

    # Objective function
    model.setObjective(2.97*x0**2 + 7.99*x0*x1 + 5.42*x0*x2 + 8.42*x1**2 + 5.13*x1*x2 + 9.59*x0 + 9.47*x1 + 1.94*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(1*x0 + 9*x1 + 12*x2 <= 386)
    model.addConstr(24*x0 + 26*x1 + 26*x2 <= 238)
    model.addConstr(x0**2 + x2**2 >= 70)
    model.addConstr(x1**2 + x2**2 >= 67)
    model.addConstr(x0 + x1 >= 88)
    model.addConstr(x0 + x1 + x2 >= 88)
    model.addConstr(26*x1 + 26*x2 >= 41)
    model.addConstr(24*x0 + 26*x1 >= 60)
    model.addConstr(24*x0 + 26*x1 + 26*x2 >= 60)
    model.addConstr(-6*x0 + 5*x2 >= 0)
    model.addConstr(9*x1**2 + 12*x2**2 <= 383)
    model.addConstr(x0 + 12*x2 <= 317)
    model.addConstr(x0**2 + x1**2 + x2**2 <= 355)
    model.addConstr(24*x0 + 26*x2 <= 161)
    model.addConstr((24*x0)**2 + (26*x1)**2 + (26*x2)**2 <= 107)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Chicken breasts: ", x0.varValue)
        print("Hamburgers: ", x1.varValue)
        print("Kiwis: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
