
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
protein = m.addVar(lb=0, name="protein")
magnesium = m.addVar(lb=0, name="magnesium")
vitamin_b7 = m.addVar(lb=0, name="vitamin_b7")


# Set objective function
m.setObjective(6.34*protein**2 + 5.25*protein*magnesium + 6.91*protein*vitamin_b7 + 2.93*magnesium**2 + 1.22*magnesium*vitamin_b7 + 8.63*vitamin_b7**2 + 2.74*protein + 9.5*magnesium + 6.94*vitamin_b7, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(13*protein + 30*magnesium + 21*vitamin_b7 <= 391, "digestive_support_index") #Given Upper Bound
m.addConstr(13*protein + 30*magnesium <= 148, "protein_magnesium_digestive_support")
m.addConstr(13*protein + 30*magnesium + 21*vitamin_b7 <= 148, "combined_digestive_support")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Protein: %g' % protein.x)
    print('Magnesium: %g' % magnesium.x)
    print('Vitamin B7: %g' % vitamin_b7.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

