
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(lb=0, name="grams_of_protein", vtype=gurobi.GRB.CONTINUOUS)
x2 = model.addVar(lb=0, name="milligrams_of_magnesium", vtype=gurobi.GRB.CONTINUOUS)
x3 = model.addVar(lb=0, name="milligrams_of_vitamin_B7", vtype=gurobi.GRB.CONTINUOUS)

# Objective function
model.setObjective(6.34*x1**2 + 5.25*x1*x2 + 6.91*x1*x3 + 2.93*x2**2 + 1.22*x2*x3 + 8.63*x3**2 + 2.74*x1 + 9.5*x2 + 6.94*x3, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 <= 391/13, name="protein_digestive_support")
model.addConstr(x2 <= 391/30, name="magnesium_digestive_support")
model.addConstr(x3 <= 391/21, name="vitamin_B7_digestive_support")
model.addConstr(x2**2 + x3**2 <= 131, name="combined_magnesium_vitamin_B7")
model.addConstr(13*x1 + 30*x2 <= 148, name="combined_protein_magnesium")
model.addConstr(13*x1 + 30*x2 + 21*x3 <= 148, name="combined_all")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Grams of protein: {x1.varValue}")
    print(f"Milligrams of magnesium: {x2.varValue}")
    print(f"Milligrams of vitamin B7: {x3.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
