
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B5
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of magnesium
    x2 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin D


    # Set objective function
    model.setObjective(6*x0**2 + 9*x0*x1 + 7*x0*x2 + 3*x1**2 + 8*x1*x2 + 9*x2**2 + 8*x0 + 2*x1, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(7.72*x0 + 0.04*x1 + 3.45*x2 <= 174, "c0")
    model.addConstr(1.06*x0 + 2.82*x1 + 6.51*x2 <= 91, "c1")
    model.addConstr(0.04*x1**2 + 3.45*x2**2 >= 33, "c2")
    model.addConstr(7.72*x0 + 3.45*x2 >= 19, "c3")
    model.addConstr(7.72*x0 + 0.04*x1 + 3.45*x2 >= 29, "c4")
    model.addConstr(1.06*x0 + 2.82*x1 >= 11, "c5")
    model.addConstr(2.82*x1**2 + 6.51*x2**2 >= 16, "c6")
    model.addConstr(1.06*x0 + 2.82*x1 + 6.51*x2 >= 23, "c7")
    model.addConstr(-5*x1 + 7*x2 >= 0, "c8")
    model.addConstr(-9*x0 + 6*x1 >= 0, "c9")
    model.addConstr(0.04*x1 + 3.45*x2 <= 122, "c10")
    model.addConstr(2.82*x1 + 6.51*x2 <= 69, "c11")
    model.addConstr(1.06*x0 + 6.51*x2 <= 50, "c12")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
