
import gurobi

def optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x2")
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x3")

    # Objective function
    model.setObjective(6*x1**2 + 9*x1*x2 + 7*x1*x3 + 3*x2**2 + 8*x2*x3 + 9*x3**2 + 8*x1 + 2*x2)

    # Constraints
    model.addConstr(7.72*x1 == 7.72, name="c1")
    model.addConstr(0.04*x2 == 0.04, name="c2")
    model.addConstr(3.45*x3 == 3.45, name="c3")
    model.addConstr(7.72*x1 + 0.04*x2 + 3.45*x3 >= 29, name="c4")
    model.addConstr(7.72*x1 + 0.04*x2 >= 19, name="c5")
    model.addConstr(1.06*x1 + 2.82*x2 >= 11, name="c6")
    model.addConstr(1.06*x1 + 2.82*x2 + 6.51*x3 >= 23, name="c7")
    model.addConstr(-5*x2 + 7*x3 >= 0, name="c8")
    model.addConstr(-9*x1 + 6*x2 >= 0, name="c9")
    model.addConstr(0.04*x2 + 3.45*x3 <= 122, name="c10")
    model.addConstr(2.82*x2 + 6.51*x3 <= 69, name="c11")
    model.addConstr(1.06*x1 + 6.51*x3 <= 50, name="c12")

    model.setAttr(gurobi.GRB.Attr.ModelSense, gurobi.GRB.MINIMIZE)

    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print("x1:", x1.varValue)
        print("x2:", x2.varValue)
        print("x3:", x3.varValue)
        print("Objective:", model.objVal)
    else:
        print("No optimal solution found.")

optimization_problem()
