
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="rubber_bands")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="monochrome_printers")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="red_pens")

    # Set objective function
    m.setObjective(9.37*x0**2 + 3.14*x1*x2 + 8.57*x0 + 1.97*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(12*x0 + 6*x1 + 4*x2 >= 76, "c1")
    m.addConstr(27*x0**2 + 17*x1**2 + 16*x2**2 >= 54, "c2")
    m.addConstr(12*x0 + 6*x1 <= 212, "c3")
    m.addConstr(12*x0**2 + 4*x2**2 <= 296, "c4")
    m.addConstr(12*x0 + 6*x1 + 4*x2 <= 296, "c5")
    m.addConstr(17*x1**2 + 16*x2**2 <= 90, "c6")
    m.addConstr(27*x0**2 + 17*x1**2 <= 193, "c7")
    m.addConstr(27*x0 + 17*x1 + 16*x2 <= 193, "c8")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
