
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="rubber_bands", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="monochrome_printers", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="red_pens", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(9.37 * x0**2 + 3.14 * x1 * x2 + 8.57 * x0 + 1.97 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(12 * x0 + 6 * x1 + 4 * x2 >= 76)
    model.addConstr(729 * x0**2 + 289 * x1**2 + 256 * x2**2 >= 54)
    model.addConstr(12 * x0 + 6 * x1 <= 212)
    model.addConstr(144 * x0**2 + 16 * x2**2 <= 296)
    model.addConstr(12 * x0 + 6 * x1 + 4 * x2 <= 296)
    model.addConstr(289 * x1**2 + 256 * x2**2 <= 90)
    model.addConstr(729 * x0**2 + 289 * x1**2 <= 193)
    model.addConstr(27 * x0 + 17 * x1 + 16 * x2 <= 193)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Rubber bands: {x0.varValue}")
        print(f"Monochrome printers: {x1.varValue}")
        print(f"Red pens: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
