
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, name="hours_worked_by_George")  # George's hours
    x1 = model.addVar(lb=0, name="hours_worked_by_Bill")  # Bill's hours


    # Set objective function
    model.setObjective(7.22*x0**2 + 3.77*x0*x1 + 7.44*x0 + 1.6*x1, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(16*x0 + 1*x1 >= 37, "organization_score_constraint")
    model.addConstr(14*x0 + 17*x1 >= 25, "productivity_rating_constraint")
    model.addConstr(-x0**2 + x1**2 >= 0, "squared_hours_constraint")
    model.addConstr(16*x0**2 + 1*x1**2 <= 79, "squared_organization_score_constraint")
    model.addConstr(16*x0 + 1*x1 <= 79, "total_organization_score_constraint")
    model.addConstr(14*x0 + 17*x1 <= 81, "total_productivity_rating_constraint")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Hours worked by George: {x0.x}")
        print(f"Hours worked by Bill: {x1.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
