
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(name='hours_worked_by_George', lb=-GRB.INFINITY, ub=GRB.INFINITY)
x1 = m.addVar(name='hours_worked_by_Bill', lb=-GRB.INFINITY, ub=GRB.INFINITY)

# Objective function: Maximize
m.setObjective(7.22*x0**2 + 3.77*x0*x1 + 7.44*x0 + 1.6*x1, GRB.MAXIMIZE)

# Constraints
m.addConstr(16*x0 + x1 >= 37, name='organization_score_min')
m.addConstr(14*x0 + 17*x1 >= 25, name='productivity_rating_min')
m.addConstr(-x0**2 + x1**2 >= 0, name='quadratic_constraint')
m.addConstr(16*x0**2 + x1**2 <= 79, name='combined_organization_score_max_squared')
m.addConstr(16*x0 + x1 <= 79, name='combined_organization_score_max')
m.addConstr(14*x0 + 17*x1 <= 81, name='combined_productivity_rating_max')

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by George: {x0.x}")
    print(f"Hours worked by Bill: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
