
import gurobi

def optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="hours_worked_by_George", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="hours_worked_by_Bill", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(7.22*x1**2 + 3.77*x1*x2 + 7.44*x1 + 1.6*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(16*x1 + x2 >= 37, name="organization_score_constraint")
    model.addConstr(14*x1 + 17*x2 >= 25, name="productivity_rating_constraint")
    model.addConstr(-x1**2 + x2**2 >= 0, name="hours_worked_constraint")
    model.addConstr((16*x1)**2 + (x2)**2 <= 79, name="organization_score_squared_constraint")
    model.addConstr(16*x1 + x2 <= 79, name="total_organization_score_constraint")
    model.addConstr(14*x1 + 17*x2 <= 81, name="total_productivity_rating_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by George: ", x1.varValue)
        print("Hours worked by Bill: ", x2.varValue)
    else:
        print("No optimal solution found")

optimization_problem()
