
from gurobipy import *

# Create a new model
m = Model("Workforce_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="Dale")
x2 = m.addVar(lb=0, name="Peggy")
x3 = m.addVar(lb=0, name="Hank")
x4 = m.addVar(lb=0, name="John")
x5 = m.addVar(lb=0, name="Mary")
x6 = m.addVar(lb=0, name="Laura")

# Objective function (example)
m.setObjective(x1 + 2*x2 + x3 + 3*x4 + x5 + x6, GRB.MINIMIZE)

# Constraints
m.addConstr(x1 + x2 >= 42)  # Example constraint
m.addConstr(27 <= x4 + x5)  # Another example constraint
m.addConstr(-x2 + 4*x3 >= 0)  # "3 times Peggy, minus 4 times Hank" constraint

# Add other constraints here...

# Optimize model
m.optimize()

# Print solution
for v in m.getVars():
    print('%s %g' % (v.varName, v.x))

print('Obj: %g' % m.objVal)
