
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="hours_worked_by_Dale", lb=0)
x1 = m.addVar(name="hours_worked_by_Peggy", lb=0)
x2 = m.addVar(name="hours_worked_by_Hank", lb=0)
x3 = m.addVar(name="hours_worked_by_John", lb=0)
x4 = m.addVar(name="hours_worked_by_Mary", lb=0)
x5 = m.addVar(name="hours_worked_by_Laura", lb=0)

# Objective function
m.setObjective(6.9*x0 + 5.6*x1 + 8.76*x2 + 5.63*x3 + 2.6*x4 + 2.4*x5, gurobi.GRB.MINIMIZE)

# Constraints
# Computer competence rating constraints
m.addConstr(12*x0 + 10*x3 + 12*x4 >= 21, name="computer_competence_Dale_John_Mary")
m.addConstr(12*x0 + 13*x1 + 2*x2 >= 15, name="computer_competence_Dale_Peggy_Hank")
# ... add all other constraints similarly

# Organization score constraints
m.addConstr(5*x0 + 15*x5 >= 37, name="organization_score_Dale_Laura")
m.addConstr(12*x2 + 5*x3 >= 21, name="organization_score_Hank_John")
# ... add all other constraints similarly

# Likelihood to quit index constraints
m.addConstr(9*x0 + 7*x4 >= 28, name="likelihood_to_quit_Dale_Mary")
m.addConstr(5*x2 + 10*x5 >= 31, name="likelihood_to_quit_Hank_Laura")
# ... add all other constraints similarly

# Work quality rating constraints
m.addConstr(2*x0 + 14*x2 >= 14, name="work_quality_Dale_Hank")
m.addConstr(2*x0 + 4*x3 >= 22, name="work_quality_Dale_John")
# ... add all other constraints similarly

# Dollar cost per hour constraints
m.addConstr(10*x0 + 2*x1 + 1*x2 + 15*x3 + 9*x4 + 4*x5 <= 304, name="dollar_cost")

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found")
    print("Hours worked by Dale:", x0.varValue)
    print("Hours worked by Peggy:", x1.varValue)
    print("Hours worked by Hank:", x2.varValue)
    print("Hours worked by John:", x3.varValue)
    print("Hours worked by Mary:", x4.varValue)
    print("Hours worked by Laura:", x5.varValue)
else:
    print("No optimal solution found")
