
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x = m.addVars(4, name=["smoke_detectors", "rubber_bands", "yellow_highlighters", "cafeteria_chairs"], vtype=gp.GRB.INTEGER)


    # Set objective function
    m.setObjective(8.31 * x[0] + 6.4 * x[1] + 4.26 * x[2] + 1.25 * x[3], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(1*x[0] + 6*x[1] + 7*x[2] + 2*x[3] <= 126, "total_cost")
    m.addConstr(2*x[0] + 7*x[1] + 2*x[2] + 7*x[3] <= 109, "total_storage")
    m.addConstr(1*x[0] + 6*x[1] + 7*x[2] >= 34, "min_cost_012")
    m.addConstr(2*x[2] + 7*x[3] >= 21, "min_storage_23")
    m.addConstr(2*x[0] + 7*x[1] >= 32, "min_storage_01")
    m.addConstr(2*x[0] + 7*x[1] + 7*x[3] >= 25, "min_storage_013")
    m.addConstr(7*x[2] + 2*x[3] <= 67, "max_cost_23")
    m.addConstr(x[0] + 6*x[1] <= 159, "max_cost_01")
    m.addConstr(6*x[1] + 2*x[3] <= 126, "max_cost_13")
    m.addConstr(2*x[0] + 7*x[1] <= 69, "max_storage_01")
    m.addConstr(7*x[1] + 7*x[3] <= 51, "max_storage_13")
    m.addConstr(7*x[1] + 2*x[2] <= 61, "max_storage_12")
    m.addConstr(7*x[1] + 2*x[2] + 7*x[3] <= 36, "max_storage_123")
    m.addConstr(2*x[0] + 2*x[2] + 7*x[3] <= 109, "max_storage_023")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f"{v.varName}: {v.x}")
        print(f"Obj: {m.objVal}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
