
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="smoke detectors", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="rubber bands", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="yellow highlighters", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="cafeteria chairs", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(8.31 * x0 + 6.4 * x1 + 4.26 * x2 + 1.25 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x0 + 6 * x1 + 7 * x2 >= 34, name="min_spend_1")
    model.addConstr(2 * x2 + 7 * x3 >= 21, name="min_storage_1")
    model.addConstr(2 * x0 + 7 * x1 >= 32, name="min_storage_2")
    model.addConstr(2 * x0 + 7 * x1 + 7 * x3 >= 25, name="min_storage_3")
    model.addConstr(7 * x2 + 2 * x3 <= 67, name="max_cost_1")
    model.addConstr(x0 + 6 * x1 <= 159, name="max_cost_2")
    model.addConstr(6 * x1 + 2 * x3 <= 126, name="max_spend_1")
    model.addConstr(x0 + 6 * x1 + 7 * x2 + 2 * x3 <= 126, name="max_total_spend")
    model.addConstr(2 * x0 + 7 * x1 <= 69, name="max_storage_1")
    model.addConstr(7 * x1 + 7 * x3 <= 51, name="max_storage_2")
    model.addConstr(7 * x1 + 2 * x2 <= 61, name="max_storage_3")
    model.addConstr(7 * x1 + 2 * x2 + 7 * x3 <= 36, name="max_storage_4")
    model.addConstr(2 * x0 + 2 * x2 + 7 * x3 <= 109, name="max_storage_5")
    model.addConstr(2 * x0 + 7 * x1 + 2 * x2 + 7 * x3 <= 109, name="max_total_storage")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Smoke detectors: {x0.varValue}")
        print(f"Rubber bands: {x1.varValue}")
        print(f"Yellow highlighters: {x2.varValue}")
        print(f"Cafeteria chairs: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
