
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x = m.addVars(4, lb=0, names=["Peggy", "Bobby", "Bill", "Jean"])

    # Set objective function
    m.setObjective(2*x[0] + 4*x[1] + 8*x[2] + 2*x[3], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(19*x[0] + 9*x[1] + 10*x[3] >= 15)
    m.addConstr(19*x[0] + 9*x[1] + 11*x[2] >= 15)
    m.addConstr(19*x[0] + 11*x[2] + 10*x[3] >= 15)
    m.addConstr(19*x[0] + 9*x[1] + 10*x[3] >= 21)
    m.addConstr(19*x[0] + 9*x[1] + 11*x[2] >= 21)
    m.addConstr(19*x[0] + 11*x[2] + 10*x[3] >= 21)
    m.addConstr(19*x[0] + 9*x[1] + 10*x[3] >= 18)
    m.addConstr(19*x[0] + 9*x[1] + 11*x[2] >= 18)
    m.addConstr(19*x[0] + 11*x[2] + 10*x[3] >= 18)
    m.addConstr(8*x[0] + 5*x[1] <= 349)
    m.addConstr(5*x[1] + 1*x[2] <= 292)
    m.addConstr(8*x[0] + 1*x[2] <= 320)
    m.addConstr(5*x[1] + 4*x[3] <= 277)
    m.addConstr(1*x[2] + 4*x[3] <= 274)
    m.addConstr(8*x[0] + 4*x[3] <= 147)
    m.addConstr(8*x[0] + 5*x[1] + 1*x[2] + 4*x[3] <= 147)
    m.addConstr(19*x[0] + 10*x[3] <= 51)
    m.addConstr(9*x[1] + 10*x[3] <= 63)
    m.addConstr(9*x[1] + 11*x[2] <= 60)
    m.addConstr(19*x[0] + 11*x[2] <= 32)
    m.addConstr(19*x[0] + 9*x[1] + 11*x[2] <= 63)
    m.addConstr(19*x[0] + 9*x[1] + 11*x[2] + 10*x[3] <= 63)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
        print(f'Obj: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
