
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Peggy
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Bobby
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Bill
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Jean

    # Objective function: maximize 2*x0 + 4*x1 + 8*x2 + 2*x3
    model.setObjective(2*x0 + 4*x1 + 8*x2 + 2*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(8*x0 <= 377)
    model.addConstr(19*x0 <= 107)
    model.addConstr(5*x1 <= 377)
    model.addConstr(9*x1 <= 107)
    model.addConstr(x2 <= 377)
    model.addConstr(11*x2 <= 107)
    model.addConstr(4*x3 <= 377)
    model.addConstr(10*x3 <= 107)

    model.addConstr(19*x0 + 9*x1 + 10*x3 >= 15)
    model.addConstr(19*x0 + 11*x2 + 9*x1 >= 15)
    model.addConstr(19*x0 + 11*x2 + 10*x3 >= 15)
    model.addConstr(19*x0 + 9*x1 + 10*x3 >= 21)
    model.addConstr(19*x0 + 9*x1 + 11*x2 >= 21)
    model.addConstr(19*x0 + 11*x2 + 10*x3 >= 21)
    model.addConstr(19*x0 + 9*x1 + 10*x3 >= 18)
    model.addConstr(19*x0 + 9*x1 + 11*x2 >= 18)
    model.addConstr(19*x0 + 11*x2 + 10*x3 >= 18)

    model.addConstr(8*x0 + 5*x1 <= 349)
    model.addConstr(5*x1 + x2 <= 292)
    model.addConstr(8*x0 + x2 <= 320)
    model.addConstr(5*x1 + 4*x3 <= 277)
    model.addConstr(x2 + 4*x3 <= 274)
    model.addConstr(8*x0 + 4*x3 <= 147)
    model.addConstr(8*x0 + 5*x1 + x2 + 4*x3 <= 147)

    model.addConstr(19*x0 + 10*x3 <= 51)
    model.addConstr(9*x1 + 10*x3 <= 63)
    model.addConstr(9*x1 + 11*x2 <= 60)
    model.addConstr(19*x0 + 11*x2 <= 32)
    model.addConstr(19*x0 + 9*x1 + 11*x2 <= 63)
    model.addConstr(19*x0 + 9*x1 + 11*x2 + 10*x3 <= 63)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
