
import gurobipy as gp

# Create a new model
m = gp.Model("maximize_food_value")

# Create variables
cantaloupes = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cantaloupes")
peanutbutter_sandwiches = m.addVar(vtype=gp.GRB.CONTINUOUS, name="peanutbutter_sandwiches")

# Set objective function
m.setObjective(3.2 * cantaloupes + 2.05 * peanutbutter_sandwiches, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * cantaloupes + 4 * peanutbutter_sandwiches >= 6, "min_fat")
m.addConstr(5 * cantaloupes - 9 * peanutbutter_sandwiches >= 0, "cantaloupe_peanutbutter_ratio")
m.addConstr(5 * cantaloupes + 4 * peanutbutter_sandwiches <= 18, "max_fat")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Number of cantaloupes: {cantaloupes.x}")
    print(f"Number of peanutbutter sandwiches: {peanutbutter_sandwiches.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

