
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="cantaloupes")
x2 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="peanutbutter_sandwiches")

# Define the objective function
m.setObjective(3.2*x1 + 2.05*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 4*x2 >= 6, "fat_minimum")
m.addConstr(5*x1 - 9*x2 >= 0, "cantaloupes_vs_sandwiches")
m.addConstr(5*x1 + 4*x2 <= 18, "fat_maximum")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cantaloupes: {x1.x}")
    print(f"Peanut butter sandwiches: {x2.x}")
else:
    print("No optimal solution found")
