
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    cantaloupes = model.addVar(name="cantaloupes", lb=0)
    peanutbutter_sandwiches = model.addVar(name="peanutbutter_sandwiches", lb=0)

    # Define the objective function
    model.setObjective(3.2 * cantaloupes + 2.05 * peanutbutter_sandwiches, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(5 * cantaloupes + 4 * peanutbutter_sandwiches >= 6, name="fat_min")
    model.addConstr(5 * cantaloupes - 9 * peanutbutter_sandwiches >= 0, name="cantaloupes_vs_sandwiches")
    model.addConstr(5 * cantaloupes + 4 * peanutbutter_sandwiches <= 33, name="fat_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Cantaloupes: {cantaloupes.varValue}")
        print(f"Peanutbutter sandwiches: {peanutbutter_sandwiches.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
