
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
tomatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="tomatoes")
bacon = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strips_of_bacon")
pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cherry_pies")
sandwiches = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peanutbutter_sandwiches")

# Set objective function
m.setObjective(9.76 * tomatoes + 4.93 * bacon + 2.25 * pies + 5.97 * sandwiches, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(21 * bacon + 16 * pies >= 46, "tastiness_bacon_pies")
m.addConstr(21 * tomatoes + 22 * sandwiches <= 86, "tastiness_tomatoes_sandwiches")
m.addConstr(21 * tomatoes + 12 * bacon <= 211, "tastiness_tomatoes_bacon")
m.addConstr(12 * bacon + 22 * sandwiches <= 230, "tastiness_bacon_sandwiches")
m.addConstr(12 * bacon + 16 * pies <= 177, "tastiness_bacon_pies_max")
m.addConstr(21 * tomatoes + 12 * bacon + 16 * pies + 22 * sandwiches <= 177, "tastiness_total")
m.addConstr(31 * tomatoes + 22 * bacon <= 228, "cost_tomatoes_bacon")
m.addConstr(31 * tomatoes + 3 * pies <= 193, "cost_tomatoes_pies")
m.addConstr(31 * tomatoes + 22 * bacon + 3 * pies + 1 * sandwiches <= 193, "cost_total")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('tomatoes:', tomatoes.x)
    print('bacon:', bacon.x)
    print('pies:', pies.x)
    print('sandwiches:', sandwiches.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

