
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="tomatoes", lb=0)  # tomatoes
    x1 = model.addVar(name="strips_of_bacon", lb=0)  # strips of bacon
    x2 = model.addVar(name="cherry_pies", lb=0)  # cherry pies
    x3 = model.addVar(name="peanutbutter_sandwiches", lb=0)  # peanutbutter sandwiches

    # Define the objective function
    model.setObjective(9.76 * x0 + 4.93 * x1 + 2.25 * x2 + 5.97 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(12 * x1 + 16 * x2 >= 46)
    model.addConstr(21 * x0 + 22 * x3 <= 86)
    model.addConstr(21 * x0 + 12 * x1 <= 211)
    model.addConstr(12 * x1 + 22 * x3 <= 230)
    model.addConstr(12 * x1 + 16 * x2 <= 177)
    model.addConstr(21 * x0 + 12 * x1 + 16 * x2 + 22 * x3 <= 177)
    model.addConstr(31 * x0 + 22 * x1 <= 228)
    model.addConstr(31 * x0 + 3 * x2 <= 193)
    model.addConstr(31 * x0 + 22 * x1 + 3 * x2 + 1 * x3 <= 193)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Tomatoes: {x0.varValue}")
        print(f"Strips of bacon: {x1.varValue}")
        print(f"Cherry pies: {x2.varValue}")
        print(f"Peanutbutter sandwiches: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
