
import gurobipy as gp

# Create a new model
m = gp.Model("minimize_food_cost")

# Create variables
cornichons = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cornichons")
bacon = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bacon")
bananas = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bananas")


# Set objective function
m.setObjective(4.4 * cornichons + 9.0 * bacon + 8.18 * bananas, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(11 * cornichons + 8 * bacon + 3 * bananas <= 147, "tastiness_limit")
m.addConstr(8 * bacon + 3 * bananas >= 41, "bacon_banana_tastiness")
m.addConstr(11 * cornichons + 8 * bacon >= 18, "cornichon_bacon_tastiness")
m.addConstr(11 * cornichons + 8 * bacon + 3 * bananas >= 18, "total_tastiness")
m.addConstr(2 * cornichons - 8 * bacon >= 0, "cornichon_bacon_ratio")
m.addConstr(-1 * bacon + 7 * bananas >= 0, "bacon_banana_ratio")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('cornichons:', cornichons.x)
    print('bacon:', bacon.x)
    print('bananas:', bananas.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

