
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, name="cornichons")  # Can be fractional
x2 = m.addVar(lb=0, name="strips_of_bacon")  # Can be non-integer
x3 = m.addVar(lb=0, name="bananas")  # Can be non-integer

# Set the objective function
m.setObjective(4.4*x1 + 9.0*x2 + 8.18*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(11*x1 + 8*x2 >= 18, name="tastiness_cornichons_bacon")
m.addConstr(11*x1 + 8*x2 + 3*x3 >= 18, name="total_tastiness_min_18")
m.addConstr(8*x2 + 3*x3 >= 41, name="bacon_bananas_tastiness")
m.addConstr(2*x1 - 8*x2 >= 0, name="cornichons_vs_bacon")
m.addConstr(-x2 + 7*x3 >= 0, name="bacon_vs_bananas")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cornichons: {x1.x}")
    print(f"Strips of Bacon: {x2.x}")
    print(f"Bananas: {x3.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
